import React, { Component } from 'react';
import { withStyles } from '@material-ui/core/styles';
import fillTemplate from 'es6-dynamic-template';
import Interweave from 'interweave';
import { SUPPORT_URL } from 'constants/urls';
import routes from 'constants/routes';
import defaultIcon from 'resources/images/models/defaultUnitIcon.svg';
import failBadgeIcon from 'resources/images/fail.svg';
import UnitImageWithBadge from 'components/UnitImageWithBadge';
import StyledButton from 'components/StyledButton';
import { Logger } from 'library/Logger';
import styles from './styles';

type Props = {
    strings: object,
    history: History,
    classes: {
        [key: string]: string
    }
};

class USBErrorScreen extends Component<Props> {
    onTryAgain() {
        const { history } = this.props;
        // Move to welcome screen
        Logger.info('USBErrorScreen - onTryAgain - moving to welcome screen');
        history.replace(routes.WELCOME.path);
    }

    render() {
        const { classes, strings } = this.props;
        return (
            <div className={classes.container}>
                <UnitImageWithBadge
                    imageIcon={defaultIcon}
                    badgeIcon={failBadgeIcon}
                    imageClasses={classes.imageIcon}
                    badgeClasses={classes.badgeIcon}
                />
                <div className={classes.subtitle}>
                    {strings.usb_connection_error}
                </div>
                <StyledButton
                    variant="outlined"
                    btnSize="big"
                    styles={classes.tryAgain}
                    onClick={() => this.onTryAgain()}
                >
                    {strings.general_button_retry}
                </StyledButton>
                <div className={classes.help}>
                    <Interweave
                        content={fillTemplate(
                            strings.problem_updating_fw_help,
                            { url: SUPPORT_URL }
                        )}
                    />
                </div>
            </div>
        );
    }
}

export default withStyles(styles)(USBErrorScreen);
